/*
 * Decompiled with CFR 0.152.
 */
package com.james.tinkerscalibration.modifiers;

import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.modifiers.impl.DurabilityShieldModifier;
import slimeknights.tconstruct.library.tools.context.EquipmentContext;
import slimeknights.tconstruct.library.tools.context.ToolRebuildContext;
import slimeknights.tconstruct.library.tools.nbt.IModDataView;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ModDataNBT;
import slimeknights.tconstruct.library.tools.stat.INumericToolStat;
import slimeknights.tconstruct.library.tools.stat.ToolStats;

public class DefenseShieldModifier
extends DurabilityShieldModifier {
    private static final ResourceLocation KEY_DEFENSESHIELD_CAP = TConstruct.getResource((String)"DefenseShield_cap");

    public Component getDisplayName(int level) {
        return super.getDisplayName();
    }

    public void addVolatileData(ToolRebuildContext context, int level, ModDataNBT volatileData) {
        this.addCapacity(volatileData, (int)(50.0f * context.getDefinition().getData().getMultiplier((INumericToolStat)ToolStats.DURABILITY)));
    }

    public int getPriority() {
        return 200;
    }

    @Nullable
    public Boolean showDurabilityBar(IToolStackView tool, int level) {
        return this.getDefenseShield(tool) < this.getCapacity(tool);
    }

    public int getDurabilityRGB(IToolStackView tool, int level) {
        if (this.getDefenseShield(tool) > 0) {
            return 6591981;
        }
        return -1;
    }

    protected ResourceLocation getShieldKey() {
        return this.getId();
    }

    public ResourceLocation getCapacityKey() {
        return KEY_DEFENSESHIELD_CAP;
    }

    public int getCapacity(IModDataView volatileData) {
        return volatileData.getInt(this.getCapacityKey());
    }

    public int getCapacity(IToolStackView tool) {
        return this.getCapacity(tool.getVolatileData());
    }

    protected int getShieldCapacity(IToolStackView tool, int level) {
        return this.getCapacity(tool);
    }

    public void setCapacity(ModDataNBT volatileData, int amount) {
        volatileData.putInt(KEY_DEFENSESHIELD_CAP, amount);
    }

    public void addCapacity(ModDataNBT volatileData, int amount) {
        this.setCapacity(volatileData, this.getCapacity((IModDataView)volatileData) + amount);
    }

    public int getDefenseShield(IToolStackView tool) {
        return this.getShield(tool);
    }

    public void setShield(ModDataNBT persistentData, int amount) {
        super.setShield(persistentData, amount);
    }

    public void setDefenseShield(IToolStackView tool, int amount) {
        this.setShield(tool, 0, amount);
    }

    public void addDefenseShield(IToolStackView tool, int amount) {
        this.addShield(tool, 0, amount);
    }

    public void onAttacked(IToolStackView tool, int level, EquipmentContext context, EquipmentSlot slotType, DamageSource source, float amount, boolean isDirectDamage) {
        Entity attacker = source.m_7639_();
        LivingEntity target = context.getEntity();
    }
}

